<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Customers extends CI_Controller {

    var $main_menu_name = "people";
	var $sub_menu_name = "customers";

	public function __construct()
	{
		parent::__construct();

		//$this->load->model('Customer_Model');
		$this->load->model('Common_Model');
		$this->load->model('api/Customer_Model','Customer_Model');
	}
	
	public function index()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
		
		$this->load->view('customers',$data);
	}
	
	public function get_customer_credit_limit(){
		$cus_id=$this->input->get('cus_id');
		$data_customer=$this->Customer_Model->get_customer_info($cus_id);	
		$cus_credit_limit=$data_customer['cus_credit_limit'];
		echo json_encode(array('cus_credit_limit'=>$cus_credit_limit));
	}

	public function create_customers()
	{
        $data['id'] = 1;
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'create_customer';
		
        if (isset($_GET['cus_id'])) {
			$cus_id=$_GET['cus_id'];
		}
		else {
			$cus_id='';
		}
		if($cus_id){
			$data['cus_id']=$cus_id;
			$data['type']='E';
			$data['pageName']='UPDATE CUSTOMER';
			$data['btnText']='Update Customer';
			$data['customer']= $this->Customer_Model->get_customer_info($cus_id);	
		}
		else {
			$data['cus_id']='';
			$data['type']='A';
			$data['pageName']='ADD CUSTOMER';
			$data['btnText']='Add Customer';
			$data['customer']=array();
		}
		$this->load->model('Marketing_Loading_Model');
		$data['routes_list']=$this->Marketing_Loading_Model->get_all_routes();
		$data['country_list'] = $this->Common_Model->get_all_country();
        $this->load->view('models/create_customer',$data);	
	}
	
	function get_all_customers() {
		$this->db->select('cus_name','cus_id');
		$this->db->order_by("cus_name", "asc");
		$this->db->where("cus_status=1");//("id !=",$id);
		$query = $this->db->get('customers');
		return $query->result_array();
	}
	
	
	public function save_customer()
	{
		$cus_id=$this->input->post('cus_id');
		$cus_code=$this->input->post('cus_code');
		$type=$this->input->post('type');
		if(!$cus_id){$cus_id=0;}
		$this->load->library('form_validation'); //form validation lib
		if($type=='A')
		{
			$this->form_validation->set_rules('cus_name', 'Customer Name', 'trim|required|xss_clean');
			if($cus_code!=''){
			 $this->form_validation->set_rules('cus_code', 'Code', 'is_unique[customer.cus_code]|trim|xss_clean');   
			}
			$this->form_validation->set_rules('cus_phone', 'Customer Phone', 'trim|required|xss_clean|is_unique[customer.cus_phone]');
			$this->form_validation->set_rules('cus_address', 'Customer Address', 'trim|required|xss_clean');
			$this->form_validation->set_rules('route_id', 'ROUTE', 'trim|required|xss_clean');
			
			$this->form_validation->set_rules('cus_email', 'E-MAIL', 'trim|xss_clean');
			$this->form_validation->set_rules('cus_state', 'GOOGLE PLACE ID', 'trim|xss_clean');
		
			$this->form_validation->set_rules('cus_postal_code', 'POSTAL CODE', 'trim|xss_clean');
			$this->form_validation->set_rules('cus_credit_limit', 'CREDIT LIMIT ', 'trim|xss_clean');
			
			
		}
		else if($type=='E')
		{
			$this->form_validation->set_rules('cus_code', 'Code', 'trim|xss_clean|required');
			$this->form_validation->set_rules('cus_name', 'Customer Name', 'trim|required|xss_clean');
			$this->form_validation->set_rules('cus_phone', 'Customer Phone', 'trim|required|xss_clean|is_unique[customer.cus_phone]');
			$this->form_validation->set_rules('cus_address', 'Customer Address', 'trim|required|xss_clean');
			$this->form_validation->set_rules('route_id', 'Route', 'trim|required|xss_clean');
		}
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            
       
            
        $country_id=$this->input->post('country_id');
		$city_name=$this->input->post('city_name');
		$cus_name=$this->input->post('cus_name');
		$cus_code=$this->input->post('cus_code');
		$cus_email=$this->input->post('cus_email');
		$cus_phone=$this->input->post('cus_phone');
		$cus_address=$this->input->post('cus_address');
		$cus_state=$this->input->post('cus_state');
		$cus_postal_code=$this->input->post('cus_postal_code');	
		$cus_credit_limit=$this->input->post('cus_credit_limit');
		$route_id=$this->input->post('route_id');
		$priority=$this->input->post('priority');
		$location=$this->input->post('location');
		$cus_warehouse_id =$this->input->post('cus_warehouse_id');
		$cus_nic =$this->input->post('cus_nic');
		$owner_name =$this->input->post('owner_name');
		
		 if($cus_code)
		{}else{
		if($type=='A'){
		$cus_code=$this->Common_Model->gen_ref_number('cus_id','customer','CUS');
		}
		}    
            
		$data=array(
			'country_id'=>$country_id,
			'cus_id'=>$cus_id,
			'city_name'=>$city_name,	
			'cus_name'=>$cus_name,
			'cus_code'=>$cus_code,
			'cus_email'=>$cus_email,
			'cus_phone'=>$cus_phone,	
			'cus_address'=>$cus_address,
			'place_id'=>$cus_state,
			'cus_postal_code'=>$cus_postal_code,
			'cus_credit_limit'=>$cus_credit_limit,
			'priority'=>$priority,
			'route_id'=>$route_id,
			'cus_warehouse_id' => $cus_warehouse_id,
			'cus_nic' => $cus_nic,
			'owner_name' => $owner_name,
		);
		
		$_insert=$this->Customer_Model->save_customer($data,$cus_id);
		$lastid=$this->db->insert_id();

		if($type=='A'){
			if ($lastid) {
				echo json_encode(array('id'=>$lastid,'type'=>$type,'status' =>1));
			} else {
				echo json_encode(array('status'=>'0'));
			}
		}
		if($type=='E'){
			echo json_encode(array('type'=>$type,'status' =>1));
		}	
			
			 //$st = array('status' =>1,'validation' => validation_errors());
            // echo json_encode($st);
		}
	}
	
	public function list_customers()
	{	
	    
	    if (isset($_SERVER['HTTP_ORIGIN'])) {
            // Decide if the origin in $_SERVER['HTTP_ORIGIN'] is one
            // you want to allow, and if so:
            header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');    // cache for 1 day
        }
            // Access-Control headers are received during OPTIONS requests
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
                // may also be using PUT, PATCH, HEAD etc
                header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");

            exit(0);
        }
	    $data = array();
    	$customers = $this->Customer_Model->get_all_customers();
    	$res = array();
    	if($customers){
    	    foreach($customers as $c){
    	        $c['system_id'] = 'Sasada';
    	        $res[] = $c;
    	        
    	    }
    	}
    	$json_data = array(
    			"data"            => $res 
    			);
    
    	echo json_encode($json_data); 
	}
	

	function delete_customer() {
		$cus_id	= $this->input->post('cus_id');
		$this->Customer_Model->delete_customer($cus_id);
        if ($cus_id) {
        	echo json_encode(array('id'=>$cus_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function disable_customer() {
		$cus_id	= $this->input->post('cus_id');
		$this->Customer_Model->disable_customer($cus_id);
        if ($cus_id) {
        	echo json_encode(array('id'=>$cus_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function enable_customer() {
		$cus_id	= $this->input->post('cus_id');
		$this->Customer_Model->enable_customer($cus_id);
        if ($cus_id) {
        	echo json_encode(array('id'=>$cus_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
}