<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
   
class Invoice_Return extends CI_Controller
{
    var $main_menu_name = "invoice_return";
    var $sub_menu_name = "invoice_return";
    private $main_model;
   
    public function __construct()
    {
       
       
        parent::__construct();
        ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL);
        date_default_timezone_set("Asia/Colombo");
       $this->load->model('Common_Model');
        $this->load->model('Invoice_Return_Model');
        $this->load->model('User_Model');
        $this->load->model('Customer_Model');
        $this->load->model('Warehouse_Model');
        $this->load->model('Product_Models');
        $this->load->model('Stock_Counter_Model');
    }
    public function index()
    {
       show_404();
    }
       
    function new_return(){
	    $data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'new_return';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['order_type_list'] = $this->Invoice_Return_Model->get_order_type();
	    $this->load->view('return/add_return_master',$data);
	}
	public function get_customer_dynamic(){
        $str = $this->input->post('search_string');
		$result=$this->Customer_Model->get_customer_for_ajex($str);
        echo json_encode($result);
    }
    public function get_user_dynamic(){
        $str = $this->input->post('search_string');
		$result=$this->User_Model->get_user_for_ajex($str,4);
        echo json_encode($result);
    }
     public function get_return_type_dynamic(){
        $str = $this->input->post('search_string');
		$result=$this->Invoice_Return_Model->get_return_type_dynamic($str);
        echo json_encode($result);
    }
    public function save_return_master()
    {
		$this->load->library('form_validation');	
		$this->form_validation->set_rules('warehouse_id', 'WAREHOUSE', 'required|xss_clean');
		$this->form_validation->set_rules('sale_rep_id', 'SALES REPRESENTATIVE', 'required|xss_clean');
		$this->form_validation->set_rules('customer_id', 'CUSTOMER', 'required|xss_clean');
		$this->form_validation->set_rules('ref_no', 'Ref No', 'xss_clean');
		$this->form_validation->set_rules('return_invoice_type', 'INVOICE TYPE', 'required|xss_clean');
		$this->form_validation->set_rules('note', 'Quntity', 'max_length[500]|xss_clean');
		$this->form_validation->set_rules('return_type_id', 'RETURN TYPE', 'required|xss_clean');
		$this->form_validation->set_rules('delivery_charge', 'DELIVERY CHARGE', 'required|xss_clean');
		$this->form_validation->set_rules('sale_id', 'INVOICE', 'required|xss_clean');
		$this->form_validation->set_rules('rtn_stock_warehouse_id', 'STOCK RETURN WAREHOUSE', 'required|xss_clean');
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
        $warehouse_id=$this->input->post('warehouse_id');
		$sale_rep_id=$this->input->post('sale_rep_id');
		$customer_id=$this->input->post('customer_id');
		$return_type_id=$this->input->post('return_type_id');
		$ref_no=$this->input->post('ref_no');
		$note=$this->input->post('note');
		$return_invoice_type=$this->input->post('return_invoice_type');
		$delivery_charge=$this->input->post('delivery_charge');
		$rtn_stock_warehouse_id=$this->input->post('rtn_stock_warehouse_id');
		$sale_id=$this->input->post('sale_id');
		$ref_data=$this->Common_Model->generate_document_ref_no(4,$warehouse_id,$return_invoice_type);
		
		
        $data=array(
			'rtn_warehouse_id'=>$warehouse_id,
			'rtn_sale_rep_id'=>$sale_rep_id,
			'rtn_customer_id'=>$customer_id,
			'rtn_manual_ref_no'=>$ref_no,
			'rtn_note'=>$note,	
			'return_invoice_type'=>$return_invoice_type,
			'return_type_id'=>$return_type_id,
			'rtn_ref_no'=>$ref_data['ref_no'],
			'added_user_id'=>$this->session->userdata('ss_user_id'),
			'added_date_time'=>date("Y-m-d H:i:s"),
			'rtn_delivery_charge'=>$delivery_charge,
			'stock_return_warehouse_id'=>$rtn_stock_warehouse_id,
			'original_invoice_id'=>$sale_id,
		);	
          $result = $this->Invoice_Return_Model->save_return($data);
          	$ref_insert_data=array(
		    'warehouse_id'=>$warehouse_id,
		    'warehouse_code'=>$ref_data['warehouse_code'],
		    'document_type_id'=>4,
		    'document_type_code'=>$ref_data['doc_type_code'],
		    'delivery_type_id'=>$return_invoice_type,
		    'delivery_type_code'=>$ref_data['delivery_type_code'],
		    'last_recode_id'=>$ref_data['last_recode_id'],
		    'primary_recode_id'=>$result,
		    );
		$this->Common_Model->insert_document_ref_no($ref_insert_data);
        $status=0;
        if($result>0){
           $status=1; 
        }
        $retun_data=array(
            'result'=>$result,
            'status'=>$status,
            );
        echo json_encode($retun_data);
		}
	}
	function add_return_items(){
	    $data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
		$data['rtn_id'] =$this->input->get('id');
		$data['details']=$this->Invoice_Return_Model->get_return_info($data['rtn_id']);
	    $this->load->view('return/add_return_items',$data);
	}
    	public function get_return_item_list() {
        $id=$this->input->get('id');
        $values = $this->Invoice_Return_Model->get_return_product_list($id);
        $totalData=count($values);
        $totalFiltered=$totalData;
         $data          = array();
	    foreach ($values as $row) {
	        $nestad_data=array();
	        $nestad_data[]  = $row['product_code'];
	        $nestad_data[]  = $row['product_name'];
	        $nestad_data[]  = $row['unit_code'];
	        //$nestad_data[]  = $row['uom_cost'];
	        $nestad_data[]  = $row['rtn_uom_price'];
	        $nestad_data[]  = $row['rtn_uom_cost'];
	        $nestad_data[]  = $row['rtn_qty'];
	        $nestad_data[]  =$row['rtn_total_value'];
	        $nestad_data[]  =$row['rtn_total_cost'];
	        $remove_button=' <button type="button" class="btn btn-danger btn-xs" data-toggle="tooltip" data-placement="bottom" title="Remove This Item"  onClick="delete_item_block('.$row['rtni_id'].')"><i class="fa fa-trash-o" aria-hidden="true"> Remove</i></button> ';
	        $edit_qty_button=' <button type="button" class="btn btn-primary btn-xs" data-toggle="tooltip" data-placement="bottom" title="Edit Quantity" onClick="update_aloacted_qty('.$row['rtni_id'].')" ><i class="fa fa-pencil-square-o" aria-hidden="true"> Qty</i></button> ';
	        $update_price='<button type="button" class="btn btn-warning btn-xs" data-toggle="tooltip" data-placement="bottom" title="Edit UOM Price" onClick="update_product_price('.$row['rtni_id'].','.$row['rtn_qty'].')" ><i class="fa fa-pencil-square-o" aria-hidden="true"> Price</i></button>';
	         $update_cost='';//'<button type="button" class="btn btn-warning btn-xs" data-toggle="tooltip" data-placement="bottom" title="Edit UOM Cost" onClick="update_product_cost('.$row['rtni_id'].','.$row['rtn_qty'].')" ><i class="fa fa-pencil-square-o" aria-hidden="true"> Cost</i></button>';
	        $action='';
	       $action=$update_cost.$edit_qty_button.$update_price.$remove_button;
	       $nestad_data[]  =$action;
	         $data[]=$nestad_data;
	    }
	     $output = array(
                'data' => $data,
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered)
            );
            echo json_encode($output);
    }
    
    public function get_product_dynamic(){
        $str = $this->input->post('search_string');
		$result=$this->Product_Models->get_search_products($str);
        echo json_encode($result);
    }
    
    public function save_return_item(){
		$this->load->library('form_validation');
		$this->form_validation->set_rules('product_id', 'Product', 'trim|required|xss_clean');
		$this->form_validation->set_rules('rtn_id', 'Main ', 'trim|required|xss_clean');
		$this->form_validation->set_rules('req_qty', 'Quntity', 'trim|required|greater_than[0]|xss_clean');
		$this->form_validation->set_rules('rtn_price', 'Price', 'trim|required|greater_than[0]|xss_clean');
		//$this->form_validation->set_rules('rtn_cost', 'Cost', 'trim|required|greater_than[0]|xss_clean');
		$this->form_validation->set_rules('return_note', 'NOTE', 'trim|xss_clean');
		$this->form_validation->set_rules('quality_level', 'CONDITION', 'trim|required|greater_than[0]|xss_clean');
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $product_id=$this->input->post('product_id');
	    	$rtn_id=$this->input->post('rtn_id');
	    	$req_qty=$this->input->post('req_qty');
	    	$quality_level=$this->input->post('quality_level');
	    	$rtn_price=$this->input->post('rtn_price');
	    	$rtn_cost=$this->input->post('rtn_cost');
	    	$return_note=$this->input->post('return_note');
           
           $item_data=$this->Invoice_Return_Model->get_sale_item_details($product_id);
           
           
           if($item_data['unit_price']<$rtn_price){
                $st = array('status' =>0,'validation' =>"Return Price Can't Be Exceed Original Invoice Price!");
                echo json_encode($st);
                return false;
           }
           
            if($item_data['quantity']<$req_qty){
                $st = array('status' =>0,'validation' =>"Return Quantity Can't Be Exceed Original Invoice Quantity!");
                echo json_encode($st);
                return false;
           }
         
           
	    	$count=$this->Invoice_Return_Model->check_already_added($item_data['product_id'],$rtn_id);
	    	if($count>0){
	    	  $st = array('status' =>0,'validation' =>'Item Already Added !');
                echo json_encode($st);
                return false;
	    	}
            $data=array(
			'rtn_id'=>$rtn_id,
			'product_id'=>$item_data['product_id'],
			'rtn_qty'=>$req_qty,	
			'rtn_request_qty'=>$req_qty,
			'rtn_uom_price'=>$rtn_price,
			'rtn_uom_cost'=>$item_data['item_cost'],
			'rtn_total_value'=>$rtn_price*$req_qty,
			'rtn_total_cost'=>$item_data['item_cost']*$req_qty,
			'quality_level'=>$quality_level,
			'rtn_item_note'=>$return_note,
			'invoice_item_id'=>$product_id,
			'original_invoice_item_price'=>$item_data['unit_price'],
			'original_invoice_item_qty'=>$item_data['quantity']
		);	
         $result=$this->Invoice_Return_Model->save_return_item($data);	   
          $st = array('status' =>1,'validation' =>'Added');
          echo json_encode($st);
		}
	}
    function delete_return_item(){
       	$this->load->library('form_validation');
		$this->form_validation->set_rules('id', 'ID', 'trim|required|xss_clean');
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $id=$this->input->post('id');
             $result=$this->Invoice_Return_Model->delete_return_item($id);	   
          $st = array('status' =>1,'validation' =>'Added');
          echo json_encode($st);
		}
    }
     public function update_return_product_price(){
		$this->load->library('form_validation');
		$this->form_validation->set_rules('id', 'ID', 'trim|required|xss_clean');
		$this->form_validation->set_rules('result', 'PRICE ', 'trim|required|greater_than[0]|xss_clean');
		$this->form_validation->set_rules('qty', 'QTY ', 'trim|required|greater_than[0]|xss_clean');
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $id=$this->input->post('id');
	    	$result=$this->input->post('result');
            $qty=$this->input->post('qty');
             $return_item_data=$this->Invoice_Return_Model->get_return_item_price_cost($id);
            if($return_item_data['original_invoice_item_price']<$result){
                $st = array('status' =>0,'validation' =>"Return Price Can't Be Exceed Original Invoice Price!");
                echo json_encode($st);
                return false;
           }
            $data=array(
			'rtn_uom_price'=>$result,
			'rtn_total_value'=>$result*$qty
		);	
         $result=$this->Invoice_Return_Model->update_return_item($id,$data);	   
          $st = array('status' =>1,'validation' =>'Added');
          echo json_encode($st);
		}
	}
		public function update_return_product_qty(){
		$this->load->library('form_validation');
		$this->form_validation->set_rules('id', 'ID', 'trim|required|xss_clean');
		$this->form_validation->set_rules('result', 'QTY ', 'trim|required|greater_than[0]|xss_clean');
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $id=$this->input->post('id');
	    	$result=$this->input->post('result');
	    	$price_cost=$this->Invoice_Return_Model->get_return_item_price_cost($id);
            if($price_cost['original_invoice_item_qty']<$result){
                $st = array('status' =>0,'validation' =>"Return Quantity Can't Be Exceed Original Invoice Quantity!");
                echo json_encode($st);
                return false;
           }
            $data=array(
			'rtn_qty'=>$result,
			'rtn_total_value'=>$price_cost['rtn_uom_price']*$result,
			'rtn_total_cost'=>$price_cost['rtn_uom_cost']*$result,
		);	
         $result=$this->Invoice_Return_Model->update_return_item($id,$data);	   
          $st = array('status' =>1,'validation' =>'Added');
          echo json_encode($st);
		}
	}
    public function update_return_product_cost(){
		$this->load->library('form_validation');
		$this->form_validation->set_rules('id', 'ID', 'trim|required|xss_clean');
		$this->form_validation->set_rules('result', 'PRICE ', 'trim|required|greater_than[0]|xss_clean');
		$this->form_validation->set_rules('qty', 'QTY ', 'trim|required|greater_than[0]|xss_clean');
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $id=$this->input->post('id');
	    	$result=$this->input->post('result');
            $qty=$this->input->post('qty');
            
            
            $data=array(
			'rtn_uom_cost'=>$result,
			'rtn_total_cost'=>$result*$qty
		);	
         $result=$this->Invoice_Return_Model->update_return_item($id,$data);	   
          $st = array('status' =>1,'validation' =>'Added');
          echo json_encode($st);
		}
	}   
	 function final_return(){
       	$this->load->library('form_validation');
		$this->form_validation->set_rules('id', 'ID', 'trim|required|xss_clean');
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $id=$this->input->post('id');
            $details=$this->Invoice_Return_Model->get_return_info($id);
             $result=$this->Invoice_Return_Model->get_return_total_values($id);
             $data=array(
			'rtn_total_cost'=>$result['total_cost'],
			'rtn_total_value'=>$result['total_price'],
	        'rtn_status'=>1,
			'added_user_id'=>$this->session->userdata('ss_user_id'),
			'added_date_time'=>date("Y-m-d H:i:s"),
			'return_note_amount'=>$result['total_price']-$details['rtn_delivery_charge']
		);
		$result=$this->Invoice_Return_Model->update_return_master($id,$data);
          $st = array('status' =>1,'validation' =>'RETURN COMPLETED');
          echo json_encode($st);
		}
        
    }
    	public function update_return_delivery_charge(){
		$this->load->library('form_validation');
		$this->form_validation->set_rules('id', 'ID', 'trim|required|xss_clean');
		$this->form_validation->set_rules('result', 'AMOUNT ', 'trim|required|greater_than[0]|xss_clean');
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $id=$this->input->post('id');
	    	$result=$this->input->post('result');
            $data=array(
			'rtn_delivery_charge'=>$result,
		);	
         $result=$this->Invoice_Return_Model->update_return_master($id,$data);	   
          $st = array('status' =>1,'validation' =>'Added');
          echo json_encode($st);
		}
	}
     function list_return(){
	    $data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'list_return';
	    $this->load->view('return/list_return',$data);
	}
	public function get_return_list($value = ''){
        $search_key     = $this->input->get('search');
        $search_key_val = $search_key['value'];
        $start          = $this->input->get('start');
        $length         = $this->input->get('length');
        $totalData      = 0;
        $values         = $this->Invoice_Return_Model->get_return_list($start, $length, $search_key_val);
        $value_count    = $this->Invoice_Return_Model->get_return_list('', '', '');
        if ($search_key_val) {
            $values_c  = $this->Invoice_Return_Model->get_return_list('', '', $search_key_val);
            $totalData = 100;  
        }
        $totalData     = $value_count;
        $totalFiltered = $totalData;
     
        $data          = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                $row=array();
                $status='<span class=" btn btn-xs btn-primary"> DRAFT</sapn>';
                if($products->rtn_status==1){
                   $status='<span class=" btn btn-xs btn-success"> COMPLETED</sapn>'; 
                }
                
                $row[]               = $products->added_date_time;
                $row[]               = $products->rtn_ref_no;
                 $row[]               = $products->rtn_manual_ref_no;
                 $row[]               = $products->m_rtn_type_name;
                $row[]               = $products->cus_code;
                $row[]               = $products->cus_name;
                $row[]               = $products->user_first_name." ".$products->user_last_name;
                $row[]               = $status;
                $row[]               = $products->return_note_amount;
                $row[]               = $products->mas_name;
                
                
                $row[]               = $products->approval_user_first_name." ".$products->approval_user_last_name;
                $row[]               = $products->approval_date_time;//$products->brm_note;
                $actdes = '';
                
                
                $option_order_details='<li><a href="' . base_url('invoice_return/return_details') .'?id=' . $products->rtn_id . '"><i class="fa fa-file-o"></i> DETAILS</a></li>';
                $update_action='<li><a href="' . base_url('invoice_return/add_return_items') . '?id=' . $products->rtn_id . '"><i class="fa fa-pencil-square-o"></i> UPDATE</a></li>';
                
                
               $action_option=''; 
              if($products->rtn_approval_status==1 || $products->rtn_status==1 ){
                  $action_option=$option_order_details;
                }else{
                    $action_option=$option_order_details.$update_action;
                }
                $actdes = $actdes . '<div class="btn-group text-left">
                            <button data-toggle="dropdown" class="btn btn-default btn-xs  dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            '.$action_option.'</ul></div>                      ';
                $row[]               = $actdes;
                $data[] = $row;
            }
            $output = array(
                'data' => $data,
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered)
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    
    	function return_details(){
	    $data['main_menu_name'] = '';
		$data['sub_menu_name'] = '';
		$data['rtn_id'] =$this->input->get('id');
		$data['details']=$this->Invoice_Return_Model->get_return_info($data['rtn_id']);
	    $this->load->view('return/return_details',$data);
	}
	
		public function get_return_item_details_list() {
        $id=$this->input->get('id');
        $values = $this->Invoice_Return_Model->get_return_product_list($id);
        $totalData=count($values);
        $totalFiltered=$totalData;
         $data          = array();
	    foreach ($values as $row) {
	       
	        $nestad_data=array();
	        $nestad_data[]  = $row['product_code'];
	        $nestad_data[]  = $row['product_name'];
	        $nestad_data[]  = $row['unit_code'];
	        //$nestad_data[]  = $row['uom_cost'];
	        $nestad_data[]  = $row['rtn_uom_price'];
	        $nestad_data[]  = $row['original_invoice_item_price'];
	        $nestad_data[]  = $row['rtn_uom_cost'];
	        $nestad_data[]  = $row['rtn_qty'];
	        $nestad_data[]  =$row['rtn_total_value'];
	        $nestad_data[]  =$row['rtn_total_cost'];
	    
	        $nestad_data[]  =$row['rtn_item_note'];;
	         $data[]=$nestad_data;
	    }
	     $output = array(
                'data' => $data,
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered)
            );
            echo json_encode($output);
    }
    
     function approval_return(){
        
	    $data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'approval_return';
	    $this->load->view('return/list_return_approval',$data);
	}
	
	public function get_return_approval_list($value = ''){
        $search_key     = $this->input->get('search');
        $search_key_val = $search_key['value'];
        $start          = $this->input->get('start');
        $length         = $this->input->get('length');
        $totalData      = 0;
        $values         = $this->Invoice_Return_Model->get_store_approval_return_list($start, $length, $search_key_val);
        $value_count    = $this->Invoice_Return_Model->get_store_approval_return_list('', '', '');
        if ($search_key_val) {
            $values_c  = $this->Invoice_Return_Model->get_store_approval_return_list('', '', $search_key_val);
            $totalData = 100;  
        }
        $totalData     = $value_count;
        $totalFiltered = $totalData;
     
        $data          = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                $row=array();
                $status='<span class=" btn btn-xs btn-primary"> DRAFT</sapn>';
                if($products->rtn_status==1){
                   $status='<span class=" btn btn-xs btn-success"> COMPLETED</sapn>'; 
                }
                
                $row[]               = $products->added_date_time;
                $row[]               = $products->rtn_ref_no;
                 $row[]               = $products->rtn_manual_ref_no;
                 $row[]               = $products->m_rtn_type_name;
                $row[]               = $products->cus_code;
                $row[]               = $products->cus_name;
                $row[]               = $products->user_first_name." ".$products->user_last_name;
                $row[]               = $status;
                $row[]               = $products->return_note_amount;
                $row[]               = $products->mas_name;
                
                
                $row[]               = $products->approval_user_first_name." ".$products->approval_user_last_name;
                $row[]               = $products->approval_date_time;//$products->brm_note;
                $actdes = '';
                
                $option_order_details='<li><a href="' . base_url('invoice_return/return_management_details') .'?id=' . $products->rtn_id . '"><i class="fa fa-file-o"></i> VIEW & APPROVAL</a></li>';
                $update_action='<li><a href="' . base_url('invoice_return/add_return_items') . '?id=' . $products->rtn_id . '"><i class="fa fa-pencil-square-o"></i> UPDATE</a></li>';
                
                
               $action_option=''; 
              if($products->rtn_approval_status==0 && $products->rtn_status==1 ){
                  $action_option=$option_order_details.$update_action;
                }else{
                    $action_option=$option_order_details;
                }
                $actdes = $actdes . '<div class="btn-group text-left">
                            <button data-toggle="dropdown" class="btn btn-default btn-xs  dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            '.$action_option.'</ul></div>                      ';
                $row[]               = $actdes;
                $data[] = $row;
            }
            $output = array(
                'data' => $data,
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered)
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
	
		function return_management_details(){
	    $data['main_menu_name'] = '';
		$data['sub_menu_name'] = '';
		$data['rtn_id'] =$this->input->get('id');
		$data['details']=$this->Invoice_Return_Model->get_return_info($data['rtn_id']);
	    $this->load->view('return/management_return_details',$data);
	}
	
	
	function  grant_approval(){
       
        $this->load->library('form_validation');
		$this->form_validation->set_rules('id', 'ID', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else{
            $id= $this->input->post('id');
              $data=array(
                    'rtn_approval_status'=>1,
                    'approval_by'=>$this->session->userdata('ss_user_id'),
                    'approval_date_time'=>date("Y-m-d H:i:s"),
                    );
                   $this->Invoice_Return_Model->update_return_master($id,$data); 
                     $st = array('status' =>1,'validation' => 'Saved');
                echo json_encode($st);
        }
   }
   
   function  reject_approval(){
       
        $this->load->library('form_validation');
		$this->form_validation->set_rules('id', 'ID', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else{
            $id= $this->input->post('id');
              $data=array(
                    'rtn_approval_status'=>2,
                    'approval_by'=>$this->session->userdata('ss_user_id'),
                    'approval_date_time'=>date("Y-m-d H:i:s"),
                    );
                   $this->Invoice_Return_Model->update_return_master($id,$data); 
                     $st = array('status' =>1,'validation' => 'Saved');
                echo json_encode($st);
        }
   }

    function mark_as_collected(){
       	$this->load->library('form_validation');
		$this->form_validation->set_rules('id', 'ID', 'trim|required|xss_clean');
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $id=$this->input->post('id');
            $details=$this->Invoice_Return_Model->get_return_info($id);
             $result=$this->Invoice_Return_Model->get_return_total_values($id);
             $data=array(
	        'pickup_status'=>1,
			'pickup_by'=>$this->session->userdata('ss_user_id'),
			'pickup_on'=>date("Y-m-d H:i:s"),
		);
		$result=$this->Invoice_Return_Model->update_return_master($id,$data);
          $st = array('status' =>1,'validation' =>'RETURN COLLECTED');
          echo json_encode($st);
		}
        
    }
	
	
	public function get_original_invoice_dynamic(){
        $str = $this->input->post('search_string');
        $return_invoice_type = $this->input->post('return_invoice_type');
        $customer_id = $this->input->post('customer_id');
         $warehouse_id = $this->input->post('warehouse_id');
        
		$result=$this->Invoice_Return_Model->get_original_invoice_dynamic($str,$return_invoice_type,$customer_id,$warehouse_id);
        echo json_encode($result);
    }
  
  
	
	
	public function get_original_invoice_item_dynamic(){
        $str = $this->input->post('search_string');
        $invoice_id = $this->input->post('invoice_id');
		$result=$this->Invoice_Return_Model->get_original_invoice_item_dynamic($str,$invoice_id);
        echo json_encode($result);
    }
	
	
	
	function return_note_print(){
	    $data['main_menu_name'] = '';
		$data['sub_menu_name'] = '';
		$data['rtn_id'] =$this->input->get('id');
		$data['details']=$this->Invoice_Return_Model->get_return_info($data['rtn_id']);
		$data['warehouse_details']=$data['details'];
		$data['customer_details']=$data['details'];
		
		$data['items']=$this->Invoice_Return_Model->get_return_product_list($data['rtn_id']);
	    $this->load->view('return/return_note_print',$data);
	}
  
    
    
    function account_approval_return(){
         $data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'account_approval_return';
	    $this->load->view('return/list_return_account_approval',$data);
    }
    
    public function get_return_account_approval_list($value = ''){
        $search_key     = $this->input->get('search');
        $search_key_val = $search_key['value'];
        $start          = $this->input->get('start');
        $length         = $this->input->get('length');
        $totalData      = 0;
        $values         = $this->Invoice_Return_Model->get_account_approval_return_list($start, $length, $search_key_val);
        $value_count    = 0;//$this->Invoice_Return_Model->get_account_approval_return_list('', '', '');
        if ($search_key_val) {
            $values_c  = $this->Invoice_Return_Model->get_account_approval_return_list('', '', $search_key_val);
            $totalData = 100;  
        }
        $totalData     = $value_count;
        $totalFiltered = $totalData;
     
        $data          = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                $row=array();
                $status='<span class=" btn btn-xs btn-primary"> DRAFT</sapn>';
                if($products->rtn_status==1){
                   $status='<span class=" btn btn-xs btn-success"> COMPLETED</sapn>'; 
                }
                
                $row[]               = $products->added_date_time;
                $row[]               = $products->rtn_ref_no;
                 $row[]               = $products->rtn_manual_ref_no;
                 $row[]               = $products->m_rtn_type_name;
                $row[]               = $products->cus_code;
                $row[]               = $products->cus_name;
                $row[]               = $products->user_first_name." ".$products->user_last_name;
                $row[]               = $status;
                $row[]               = $products->return_note_amount;
                $row[]               = $products->mas_name;
                
                
                $row[]               = $products->approval_user_first_name." ".$products->approval_user_last_name;
                $row[]               = $products->approval_date_time;//$products->brm_note;
                $actdes = '';
                
                $option_order_details='<li><a href="' . base_url('invoice_return/return_account_details') .'?id=' . $products->rtn_id . '"><i class="fa fa-file-o"></i> VIEW & APPROVAL</a></li>';
                $update_action='<li><a href="' . base_url('invoice_return/add_return_items') . '?id=' . $products->rtn_id . '"><i class="fa fa-pencil-square-o"></i> UPDATE</a></li>';
                
                
               $action_option=''; 
              if($products->rtn_approval_status==0 && $products->rtn_status==1 ){
                  $action_option=$option_order_details.$update_action;
                }else{
                    $action_option=$option_order_details;
                }
                $actdes = $actdes . '<div class="btn-group text-left">
                            <button data-toggle="dropdown" class="btn btn-default btn-xs  dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            '.$action_option.'</ul></div>                      ';
                $row[]               = $actdes;
                $data[] = $row;
            }
            $output = array(
                'data' => $data,
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered)
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
	
    
    
    
   
   
    function return_account_details(){
	    $data['main_menu_name'] = '';
		$data['sub_menu_name'] = '';
		$data['rtn_id'] =$this->input->get('id');
		$data['details']=$this->Invoice_Return_Model->get_return_info($data['rtn_id']);
	    $this->load->view('return/accout_return_details',$data);
	}
    
    
    	public function get_account_return_item_details_list() {
        $id=$this->input->get('id');
        $values = $this->Invoice_Return_Model->get_return_product_list($id);
        $totalData=count($values);
        $totalFiltered=$totalData;
         $data          = array();
	    foreach ($values as $row) {
	       
	        $nestad_data=array();
	        $nestad_data[]  = $row['product_code'];
	        $nestad_data[]  = $row['product_name'];
	        $nestad_data[]  = $row['unit_code'];
	        $nestad_data[]  = $row['original_invoice_item_price'];
	        $nestad_data[]  = $row['rtn_uom_cost'];
	        $nestad_data[]  = $row['rtn_request_qty'];
	        $nestad_data[]  = $row['rtn_uom_price'];
	        $nestad_data[]  = $row['rtn_qty'];
	        $nestad_data[]  =$row['rtn_total_value'];
	        $nestad_data[]  =$row['rtn_total_cost'];
	    
	        $nestad_data[]  =$row['rtn_item_note'];;
	         $data[]=$nestad_data;
	    }
	     $output = array(
                'data' => $data,
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered)
            );
            echo json_encode($output);
    }
    
    
    	function  grant_account_approval(){
       
        $this->load->model('Sale_Multiple_Payment_Model');
        $this->load->model('Dispatch_Model');
        $this->load->library('form_validation');
		$this->form_validation->set_rules('id', 'ID', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else{
           $id= $this->input->post('id');
            $master_data=$this->Invoice_Return_Model->get_return_info($id);
            $item_data=$this->Invoice_Return_Model->get_return_product_list($id);
            $old_in_smp_last_id = $this->Sale_Multiple_Payment_Model->get_next_ref_no();
            $old_in_smp_last_id = $old_in_smp_last_id->smp_id;
            $smp_last_id        = $old_in_smp_last_id + 1;
            $smp_no             = 'MP/' . sprintf('%04d', $smp_last_id);
            $sp_data_item       = array(
            'smp_last_id' => $smp_last_id,
            'smp_amount' => $master_data['return_note_amount'],
            'smp_no' => $smp_no,
            'user_id' => $this->session->userdata('ss_user_id'),
            'customer_id' => $master_data['rtn_customer_id'],
            'smp_added_date' => date("Y-m-d h:i:s") ,
            'warehouse_id' => $master_data['rtn_warehouse_id'],
            'payment_type' => 5,
            'payment_status' => 0,            
            'payment_ref_no' => $master_data['rtn_ref_no'],     
            'payment_date' =>  date("Y-m-d h:i:s") ,  
            'ref_no' => $master_data['rtn_manual_ref_no'] ,
        );
        $this->Sale_Multiple_Payment_Model->save_sale_multiple_payment_header($sp_data_item);
       
             $price_variance_count=0;   
             $dummy_invoice_total=0;
           foreach($item_data as $itm){
               
            $batch_code=$this->Common_Model->gen_ref_number('batch_id','batch_product','BRN');
             $batch_data=array(
			'grn_item_id'=>$itm['rtn_id'],
			'product_id'=>$itm['product_id'],
			'batch_ref_number'=>$batch_code,	
			'product_cost'=>$itm['rtn_uom_price'],
			'product_price'=>$itm['rtn_uom_price'],
			'credit_salling_price'=>$itm['rtn_uom_price'],
			'wholesale_price'=>$itm['rtn_uom_price'],	
			'retail_cash'=>$itm['rtn_uom_price'],
			'retail_credit'=>$itm['rtn_uom_price'],
			'retail_wholesale'=>$itm['rtn_uom_price'],
			'user_id'=>$this->session->userdata('ss_user_id'),
			'grn_type'=>2
		    );
		    $last_batch_id=$this->Invoice_Return_Model->insert_batch_table($batch_data);
            $stock_data=array(
            'return_master_id'=>$itm['rtn_id'],
             'return_item_id'=>$itm['rtni_id'],
              'product_id'=>$itm['product_id'],
               'batch_id'=>$last_batch_id,
                'returned_qty'=>$itm['rtn_qty'],
                 'returned_uom_cost'=>$itm['rtn_uom_cost'],
                  'returned_uom_price'=>$itm['rtn_uom_price'],
                   'returned_total_cost'=>$itm['rtn_total_cost'],
                    'returned_total_price'=>$itm['rtn_total_value'],
                     'added_by'=>$this->session->userdata('ss_user_id'),
                      'added_on'=> date("Y-m-d h:i:s"),
                      'returned_warehouse_id'=>$master_data['stock_return_warehouse_id'] 
            
            );
            $this->Invoice_Return_Model->insert_return_stock_table($stock_data); 
            if($itm['original_invoice_item_price']!=0){
                if($itm['original_invoice_item_price']!=$itm['rtn_uom_price']){
                    $price_variance_count++;
                    $dummy_invoice_total+=($itm['original_invoice_item_price']-$itm['rtn_uom_price']);
                }
            }
           } 
           if($price_variance_count>0){
                $invoice_data=array(
			'warehouse_id'=>$master_data['rtn_warehouse_id'],
			'sales_rep_id'=>1,
			'customer_id'=>$master_data['rtn_customer_id'],
			'bill_no'=>$master_data['rtn_manual_ref_no'],
			'card_ref_number'=>$master_data['rtn_ref_no'],
			'sale_note'=>$master_data['rtn_note'],	
			'invoice_type'=>2,
			'price_type'=>1,
			'delivery_charge'=>0,
			'sale_reference_no'=>$this->Common_Model->gen_ref_number('sale_id','sales','DMY'),
			'user'=>$this->session->userdata('ss_user_id'),
			'sale_datetime'=>date('Y-m-d H:i:s', strtotime($master_data['added_date_time'])),
			'sale_datetime_created'=>date("Y-m-d H:i:s"),
			'cost_total'=>0,
			'sale_total'=>$dummy_invoice_total,
			'sale_inv_total'=>$dummy_invoice_total,
			'sale_inv_gross_total'=>$dummy_invoice_total,
			'sale_status'=>0,
			'payment_status'=>1,
		);  
		$last_id=$this->Dispatch_Model->save_invoice_master($invoice_data);
           }
              $data=array(
                    'account_approval_status'=>1,
                    'account_approval_on'=>$this->session->userdata('ss_user_id'),
                    'account_approval_on'=>date("Y-m-d H:i:s"),
                    );
                   $this->Invoice_Return_Model->update_return_master($id,$data); 
                     $st = array('status' =>1,'validation' => 'Saved');
                echo json_encode($st);
        }
        
        
   }
    
    
  
    function  reject_account_approval(){
       
        $this->load->library('form_validation');
		$this->form_validation->set_rules('id', 'ID', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else{
            $id= $this->input->post('id');
              $data=array(
                    'account_approval_status'=>2,
                    'account_approval_on'=>$this->session->userdata('ss_user_id'),
                    'account_approval_on'=>date("Y-m-d H:i:s"),
                    );
                   $this->Invoice_Return_Model->update_return_master($id,$data); 
                     $st = array('status' =>1,'validation' => 'Saved');
                echo json_encode($st);
        }
   }
    
    
    
    
    
    
    
    
    
	
	
















    
   
	

	

	
	
	
    
   
	

    
    
    
    
    
   
	

    
    
    
     
   
   	public function save_order_item_with_batch(){
		$this->load->library('form_validation');
		$this->form_validation->set_rules('product_id', 'Product', 'trim|required|xss_clean');
		$this->form_validation->set_rules('odr_id', 'Main ', 'trim|required|xss_clean');
		$this->form_validation->set_rules('req_qty', 'Quntity', 'trim|required|greater_than[0]|xss_clean');
		$this->form_validation->set_rules('price_type', 'Price type', 'trim|required|greater_than[0]|xss_clean');
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $batch_id=$this->input->get('id');
            $product_id=$this->input->post('product_id');
	    	$odr_id=$this->input->post('odr_id');
	    	$req_qty=$this->input->post('req_qty');
	    	$price_type=$this->input->post('price_type');
	    	$price_important=$this->input->post('price_important');
	    	$count=$this->Order_Model->check_already_added($product_id,$odr_id);
	    	if($count>0){
	    	  $st = array('status' =>0,'validation' =>'Item Already Added !');
                echo json_encode($st);
                return false;
	    	}
	    	$price_cost=$this->Order_Model->get_batch_details($batch_id);
	    	$price=0;
	    	if($price_type==1){
	    	   $price= $price_cost['product_price'];
	    	}
	    	if($price_type==2){
	    	   $price= $price_cost['credit_salling_price'];
	    	}
	    	if($price_type==3){
	    	   $price= $price_cost['wholesale_price'];
	    	}
	    	$cost= $price_cost['product_cost'];
	    	
            $data=array(
			'odr_id'=>$odr_id,
			'product_id'=>$product_id,
			'request_qty'=>$req_qty,	
			'approved_qty'=>$req_qty,
			'uom_price'=>$price,
			'uom_cost'=>$cost,
			'total_price'=>$price*$req_qty,
			'total_cost'=>$cost*$req_qty,
			'price_important'=>1,
			'batch_id'=>$batch_id,
			'is_batch_validate'=>1,
			 'original_uom_price'=>$price
		);	
         $result=$this->Order_Model->save_order_item($data);	   
          $st = array('status' =>1,'validation' =>'Added');
          echo json_encode($st);
		}
	}
	

    
    
    	function management_order_details(){
	    $data['main_menu_name'] = '';
		$data['sub_menu_name'] = '';
		$data['odr_id'] =$this->input->get('id');
		$data['details']=$this->Order_Model->get_order_info($data['odr_id']);
	    $this->load->view('order/management_order_details',$data);
	}

   
  
}