<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
 header('Access-Control-Allow-Origin: *');   
class PO_API extends CI_Controller
{
    var $main_menu_name = "stock_transfer";
    var $sub_menu_name = "stock_transfer";
    private $main_model;
   
    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Colombo");
        $this->load->model('Common_Model');
        $this->load->model('User_Model');
        $this->load->model('Customer_Model');
        $this->load->model('Warehouse_Model');
        $this->load->model('API_Model');
        $this->load->model('Stock_Counter_Model');
        $this->load->model('Purchases_Model');
        
        ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL);
    }
    public function index()
    {
       show_404();
    }
    
    
    
    
    function new_po_grn(){
        
	    $data['main_menu_name'] = 'new_po_grn';
		$data['sub_menu_name'] = 'new_po_grn';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['outlet_list']=array();
		$this->load->view('grn/add_pending_po_grn',$data); 
	}
	
	
	public function save_po()
    {
        $this->load->library('form_validation');	
		$this->form_validation->set_rules('warehouse_id', 'WAREHOUSE', 'required|xss_clean');
		$this->form_validation->set_rules('ref_no', 'Ref No', 'xss_clean');
		$this->form_validation->set_rules('po_no', 'PO', 'required|xss_clean');
		$this->form_validation->set_rules('note', 'Quntity', 'max_length[500]|xss_clean');
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'message' => validation_errors());
           echo json_encode($st);
        }
        else
        {
        
        $warehouse_id=$this->input->post('warehouse_id');
		$po_no=$this->input->post('po_no');
		$ref_no=$this->input->post('ref_no');
		$note=$this->input->post('note');
	
        //---------------------------------------------------------------
        $url ="http://admin.sd.newviableerp.com/api/get_po_details?po=".$po_no;
        $ch = curl_init($url);
        $headers = array(
            "Content-Type: application/json"
            );
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $response = curl_exec($ch);
        curl_close($ch);
        //header("Content-type: application/json");
        $object = json_decode($response);
        //---------------------------------------------------------------
        
        $item_data=$object->po_items;
        $operation=1;
        $err_product_code='';
        $total_grn_value=0;
        foreach($item_data as $pd){
            $product_id=$this->API_Model->get_product_id($pd->product_code);
            if($product_id==0){$operation=0; $err_product_code.=$pd->product_code." , "; }
            $total_grn_value+=($pd->product_cost*$pd->poitm_qty);
        }
        if($operation==0){
            $data_return = array(
                    "status" => 0,
                    "message" => "PRODUCT CODE NOT FOUND : ".$err_product_code,
                    "err_code" => "error-400-i"
                );
                echo json_encode($data_return); 
                return false;
        }
        
       $master_data=$object->purchase_order;
        	if($warehouse_id==4){
				    $purchases_ref_no= $this->Common_Model->gen_ref_number('id','purchases','PODS');
				}else{
				    if($warehouse_id==10){
				    $purchases_ref_no= $this->Common_Model->gen_ref_number('id','purchases','POGR');
				    }else{
				        if($warehouse_id==11){
				         $purchases_ref_no= $this->Common_Model->gen_ref_number('id','purchases','POCN') ;  
				        }else{
				        $purchases_ref_no= $this->Common_Model->gen_ref_number('id','purchases','GRN');
				        }
				    }
				}
       $data = array(
       'reference_no' => $purchases_ref_no ,
       'warehouse_id' => $warehouse_id,
       'supplier_id'  => $master_data->supp_id,
       'date'         => date("Y-m-d H:i:s"),
       'note'         => $note,
       'total'        => $total_grn_value,
       'grand_total'  => $total_grn_value,
       'discount'     => 0,
       'discount_cal' => 0,
	   'supp_invocie_no'=>$ref_no
        );
      $last_id=$this->API_Model->save_grn_master($data);  
      foreach($item_data as $pd){
        $product_id=$this->API_Model->get_product_id($pd->product_code);
          $data_array = array(
            'purchase_id' => $last_id,
            'product_name' => $pd->product_name,
            'product_code' => $pd->product_code,
            'product_id' => $product_id,
            'quantity' => $pd->poitm_qty,
            'unit_price' => $pd->product_cost,
            'retail_price' => 0,
            'sub_total' => $pd->product_cost*$pd->poitm_qty,
        );
        $this->API_Model->save_grn_items($data_array);
        }
        $data_return = array(
                    "status" => 1,
                    "message" => "SAVED!",
                    "err_code" => "error-400-i",
                    "result"=>$last_id
                );
        echo json_encode($data_return);
    }
}
    
    
  	function new_po_grn_items(){
	    $data['main_menu_name'] = 'new_po_grn';
		$data['sub_menu_name'] = 'new_po_grn';
		$data['grn_id'] =$this->input->get('id');
		$data['details']=$this->Purchases_Model->getGrnDetails($data['grn_id']);
	    $this->load->view('grn/add_pending_po_grn_items',$data);
	}  
    
    
    	public function get_grn_item_list() {
        $id=$this->input->get('id');
        $values = $this->Purchases_Model->getGRNItems($id);
        $totalData=count($values);
        $totalFiltered=$totalData;
         $data          = array();
	    foreach ($values as $row) {
	       
	        $nestad_data=array();
	        $nestad_data[]  = $row['product_code'];
	        $nestad_data[]  = $row['product_name'];
	      //  $nestad_data[]  = '';//$row['unit_code'];
	        //$nestad_data[]  = $row['uom_cost'];
	       // $nestad_data[]  = $row['product_retail_pirce'];
	        $nestad_data[]  = $row['quantity'];
	     $nestad_data[]  = $row['unit_price'];
	      $nestad_data[]  = $row['quantity']*$row['unit_price'];
	        
	        $remove_button=' <button type="button" class="btn btn-danger btn-xs" data-toggle="tooltip" data-placement="bottom" title="Remove This Item"  onClick="delete_item_block('.$row['id'].')"><i class="fa fa-trash-o" aria-hidden="true"> Remove</i></button> ';
	       $edit_qty_button=' <button type="button" class="btn btn-primary btn-xs" data-toggle="tooltip" data-placement="bottom" title="Edit Quantity" onClick="update_aloacted_qty('.$row['id'].')" ><i class="fa fa-pencil-square-o" aria-hidden="true"> Qty</i></button> ';
	        $action='';
	       $action.=$edit_qty_button.$remove_button;
	        
	       $nestad_data[]  =$action;
	         $data[]=$nestad_data;
	    }
	     $output = array(
                'data' => $data,
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered)
            );
            echo json_encode($output);
    }
    
    public function update_grn_product_qty(){
		$this->load->library('form_validation');
		$this->form_validation->set_rules('id', 'ID', 'trim|required|xss_clean');
		$this->form_validation->set_rules('result', 'QTY ', 'trim|required|greater_than[0]|xss_clean');
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $id=$this->input->post('id');
	    	$result=$this->input->post('result');
	    	$price_cost=$this->Purchases_Model->get_grn_item_cost($id);
            $data=array(
			'sub_total'=>$price_cost['unit_price']*$result,
			'quantity'=>$result,
		);	
         $result=$this->Purchases_Model->update_grn_item($id,$data);	   
          $st = array('status' =>1,'validation' =>'Added');
          echo json_encode($st);
		}
	}
    
    
     function delete_grn_item(){
       	$this->load->library('form_validation');
		$this->form_validation->set_rules('id', 'ID', 'trim|required|xss_clean');
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $id=$this->input->post('id');
             $result=$this->Purchases_Model->delete_grn_item($id);	   
          $st = array('status' =>1,'validation' =>'Added');
          echo json_encode($st);
		}
        
    }
    
    
     function final_grn(){
       	$this->load->library('form_validation');
		$this->form_validation->set_rules('id', 'ID', 'trim|required|xss_clean');
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $id=$this->input->get('id');
            $total=$this->Purchases_Model->getGRNsum($id);
             $data=array(
	        'total'=>$total,
	        'grand_total'=>$total,
		);
		$result=$this->Purchases_Model->update_grn_master($id,$data);
		    
		}
          $st = array('status' =>1,'validation' =>'GRN COMPLETED');
          echo json_encode($st);
		}
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
   
  
}