<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Android_Model extends CI_Model {
  
  private $tableName = '';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
    
   
	function get_all_customers() {
		$this->db->select($this->tableName.'.*');		
		$this->db->order_by("cus_id", "asc");
		$this->db->where("cus_status",1);//("id !=",$id);
		$this->db->where("cus_type","normal");
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	
	function order_price_type(){
	    $this->db->select('*');		
		$query = $this->db->get('order_price_type');
		return $query->result_array();
	}
	
	
	function peyment_term(){
	    $this->db->select('pay_term_id,pay_term_name,pay_term_in_days');		
		$query = $this->db->get('master_payment_term');
		return $query->result_array();
	}
	
	function get_product_list(){
	    $this->db->select('p.*');	
	    $this->db->from('product p');
		$query = $this->db->get();
		return $query->result_array();
	}
	function get_validated_product_batch_list(){
	    $this->db->select('b.*');
	    $this->db->from('batch_product b');
	    $this->db->join('product p','p.product_id=b.product_id','inner');
	    $this->db->where("b.batch_status",1);
	    $this->db->where("p.is_batch_validate",1);
	    $this->db->where("p.product_status",1);
	    $this->db->group_by('b.batch_id');
		$query = $this->db->get();
		return $query->result_array();
	}


	
   function save_log_android_transaction ($data)
   {
	 $result=$this->db->insert('log_android',$data);
	 return  $result;	   
   }
   
   function save_transaction_log ($data)
   {
	 $result=$this->db->insert('transaction_log',$data);
	 return  $result;	   
   }
   function save_visitlocation_log ($data)
   {
	 $result=$this->db->insert('visit_location',$data);
	 return  $result;	   
   }
     public function get_registered_device($user_id,$device_id,$code)
	{
	    $this->db->select('m.mr_id,m.activation_status');  
		$this->db->from('mobile_register m');
		$this->db->where("m.activation_code",$code);	
		$this->db->where("m.device_id",$device_id);
		$this->db->where("m.user_id",$user_id);
		$query=$this->db->get();
		return $query->row_array();
	}
	function save_activation_code($data)
	{
		return $this->db->insert('mobile_register',$data);
	}
	function save_sales($data)
	{
		return $this->db->insert('mobile_invoice_data_backup_master',$data);
	}
	function save_sales_item($data)
	{
		return $this->db->insert('mobile_invoice_data_backup_item',$data);
	}
	function save_backup_payment($data)
	{
		return $this->db->insert('mobile_payment_backup_master',$data);
	}
	function save_backup_payment_items($data)
	{
		return $this->db->insert('mobile_payment_backup_item',$data);
	}

    function get_pending_order_list($user_id='',$date=''){
	    $this->db->select('o.*,c.cus_name,c.cus_code');
	    $this->db->from('order_master o');
	    $this->db->join('customer c','c.cus_id=o.odr_customer_id','inner');
	    $this->db->where("o.odr_status",1);
	   // $this->db->where("o.pickup_status",0);
	    // $this->db->where("o.odr_approval_status",1);
	    if($user_id){
	     $this->db->where("o.odr_sale_rep_id ",$user_id);
	    }
	     if($date){
	         $this->db->where("date(o.added_date_time)",$date);
	     }
		$query = $this->db->get();
		return $query->result_array();
	}
   
   
   
   
}